#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   mcastAgentStatus = context.lookup( 'routing6/multicast/agentstatus' )
   runnability = [ { 'entity' : mcastAgentStatus,
                     'qualAttr' : 'pimsmEnabled' } ]

   agentCfg = { "name": "Pimsm6",
                "exe": "/usr/bin/Pimsm6",
                "argv": [],
                "heartbeatPeriod": 30,
                "oomScoreAdj" : -50, #  see AID3426
                "runnability": runnability }

   role = { 'rpr' : context.activeSupervisorRoleName,
            'sso' : context.allSupervisorsRoleName }

   context.agentConfigIs( role, agentCfg )
