# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# This generates a dependency on Launcher
# pkgdeps: import LauncherContext

def Plugin( context ):
   # Run PlatformSecurity agent unconditionally on all supes/cells

   tpmPresencePath = "hardware/cell/%cellId/tpm/launcherConfig/%*"
   agentName = "PlatformSecurity"
   agentCfg = { "name": agentName,
                "exe": "/usr/bin/" + agentName,
                "argv": [],
                "heartbeatPeriod": 60,
                'runnability': [ { 'qualPath': tpmPresencePath } ]
   }
   role = context.allSupervisorsRoleName
   context.agentConfigIs( role, agentCfg )
