#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Cell

# Import used to generate dependency on Launcher
# pkgdeps: import LauncherContext

def Plugin( context ):

   # PlxPcieAgent runs on a given cell when the Hardware::Scd for that cell exists
   # in "hardware/cell/<cellId>".

   switchConfigDir = \
      context.lookup( f"hardware/pcieSwitch/config/cell/{Cell.cellId()}" )
   runnability = [
      {
         "entity" : switchConfigDir,
         "qualAttr" : "hasPlx"
      }
   ]
   agentCfg = { "name" : "PlxPcie",
                "exe" : "/usr/bin/PlxPcie",
                "argv" : [],
                "heartbeatPeriod" : 30,
                "runnability" : runnability }

   roleName = context.allCellsRoleName
   context.agentConfigIs( roleName, agentCfg )

   # Register the system version of the agent, this
   # controls plx switches which aren't tied to supervisors

   agentCfg = { "name" : "PlxPcie-system",
                "exe" : "/usr/bin/PlxPcie",
                "heartbeatPeriod" : 30 }

   agentCfg[ "runnability" ] = [
      { "qualPath" : "hardware/pcieSwitch/config/launcher/plx/%sliceId" },
      { "qualPath" :
        "cell/%cellId/hardware/pcieSwitch/config/anchor/plx/%sliceId" } ]
   agentCfg[ "argv" ] = [ "--system", "--sliceId=%(sliceId)s" ]
   agentCfg[ "launchName" ] = "PlxPcie"

   context.agentConfigIs( roleName, agentCfg )
