# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext
from FlowTrackerCliUtil import getSampledFlowTrackingCliConfigPath

def Plugin( context ):
   # PostcardTelemetry agent runs if
   # 1) Sflow Agent is not running/configured when sflow interop is not supported and
   # 2) Inband Telemetry is disabled
   # 3) Sampled/Hardware flow-tracking is disabled
   # 4) Postcard Telemetry is enabled
   sflowConfig = context.lookup( "sflow/config" )
   sflowStatus = context.lookup( "sflow/status" )
   sftConfig = context.lookup( getSampledFlowTrackingCliConfigPath() )
   sftLauncherPath = 'flowtracking/activeAgent/sft'
   intConfig = context.lookup( 'inbandtelemetry/config' )
   intLauncherPath = 'flowtracking/activeAgent/inbandTelemetry'

   hwCapability = context.lookup( 'postcardtelemetry/hwCapability' )
   postcardConfig = context.lookup( 'postcardtelemetry/policyconfig' )
   postcardLauncherPath = 'postcardtelemetry/activeAgent/postcardTelemetry'
   startupGracePeriod = 300
   runnability = [
      (
         { 'entity': hwCapability, 'qualAttr': 'postcardTelemetrySupported' },
         [
            { 'entity': hwCapability,
              'qualAttr': 'postcardTelemetrySflowInteropSupported',
            },
            (
               { 'entity': sflowConfig, 'qualAttr': 'enabled', 'negate': True },
               { 'entity': sflowStatus, 'qualAttr': 'active', 'negate': True },
            ),
         ],
         { 'entity': intConfig, 'qualAttr': 'enable', 'negate': True },
         { 'entity': sftConfig, 'qualAttr': 'enabled', 'negate': True },
         { 'entity': postcardConfig, 'qualAttr': 'enable' },
         { 'qualPath': sftLauncherPath, 'negate': True },
         { 'qualPath': intLauncherPath, 'negate': True },
      ),
      { 'qualPath': postcardLauncherPath },
   ]

   agentCfg = { 'name': 'PostcardTelemetry',
                'launchName': 'PostcardTelemetry',
                'exe': '/usr/bin/PostcardTelemetry',
                'argv': [],
                'heartbeatPeriod': 30,
                "startupGracePeriod": startupGracePeriod,
                "runnability": runnability }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
