#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   config = context.lookup( 'hardware/powerSupply/slot/config' )
   status = context.lookup( 'hardware/powerSupply/slot/status' )

   # Configure the PowerSupplyDetector to run on the "ActiveSupervisor" whenever
   # power supply slot exists

   agentName = 'PowerSupplyDetector'
   agentCfg = { 'name' : agentName,
                'exe' : '/usr/bin/PowerSupplyDetector',
                'argv' : [],
                'heartbeatPeriod' : 30,
                'runnability' : [ { 'entity' : config,
                                    'qualAttr' : 'slotConfig' },
                                  { 'entity' : status,
                                    'qualAttr' : 'slotStatus' } ] }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
