#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):

   #-------------------------------------------------------------------------
   # Ptp runs only on the active supervisor. This may need to change once
   # we have Ptp on modular.
   #-------------------------------------------------------------------------
   roleName = context.activeSupervisorRoleName
   ptpConfig = context.lookup( 'ptp/config' )
   ptpStatus = context.lookup( 'ptp/status' )

   def configureAgent( name, exe ):
      agentName = name
      agentCfg = { "name" : agentName,
                   "exe" : exe,
                   "argv" : [],
                   "heartbeatPeriod" : 30,
                   "oomScoreAdj" : -350, #  see AID3426
                   "runnability": [ { "entity" : ptpConfig,
                                      "qualAttr" : "enabled" },
                                    { "entity" : ptpStatus,
                                      "qualAttr" : "enabled" } ] }
      context.agentConfigIs( roleName, agentCfg )

   configureAgent( "Ptp", "/usr/bin/Ptp" )
