#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   fruConfig = context.lookup( 'ptpTimeSync/config' )
   ptpConfig = context.lookup( 'ptp/config' )
   ptpTimeSyncStatus = context.lookup( 'ptpTimeSync/status/global' )
   timestampFeatureStatus = context.lookup( 'ptpTimeSync/featureStatus' )

   ptpTimeSyncSupported = { 'entity' : fruConfig,
                            'qualAttr' : 'supported' }
   ptpConfigured = { 'entity' : ptpConfig,
                     'qualAttr' : 'ptpMode' }
   ptpTimeSyncAlwaysOn = { 'entity': fruConfig,
                           'qualAttr': 'alwaysOn' }
   ptpTimeSyncNotAlwaysOff = { 'entity': fruConfig,
                               'qualAttr': 'alwaysOff',
                               'negate': True }
   timestampFeatureEnabled = { 'entity': timestampFeatureStatus,
                               'qualAttr': 'enabled' }

   ptpTimeSyncNotDisabled = { 'entity' : ptpTimeSyncStatus,
                              'qualAttr' : 'state' }

   agentName = "PtpTimeSync"
   agentCfg = { 'name' : agentName,
                'exe' : '/usr/bin/PtpTimeSync',
                'argv' : [],
                'heartbeatPeriod' : 30,
                'oomScoreAdj' : -350, #  see AID3426
                'runnability' : ( ptpTimeSyncSupported,
                                  ptpTimeSyncNotAlwaysOff,
                                  [ ptpConfigured,
                                    timestampFeatureEnabled,
                                    ptpTimeSyncAlwaysOn,
                                    ptpTimeSyncNotDisabled ] ) }
   role = { 'rpr' : context.activeSupervisorRoleName,
            'sso' : context.allSupervisorsRoleName }
   context.agentConfigIs( role, agentCfg )
