#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pkgdeps : import LauncherContext
from Toggles.RadiusToggleLib import toggleDot1xRadiusProxyMergeV0Enabled

def Plugin( context ):
   # In case of toggle Dot1xRadiusProxyMergeV0, it will be taken care by Dot1x
   if toggleDot1xRadiusProxyMergeV0Enabled():
      return
   config = context.lookup( 'radiusproxy/config' )
   roleName = context.activeSupervisorRoleName
   agentName = 'RadiusProxy'
   exeName = '/usr/bin/RadiusProxy'
   agentCfg = { 'name': agentName,
                'exe': exeName,
                'argv': [],
                'heartbeatPeriod' : 30,
                'runnability' :  [ { 'entity' : config,
                                     'qualAttr' : 'radiusProxyEnabled' },
                                  ]
               }
   context.agentConfigIs( roleName, agentCfg )
