#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps : import LauncherContext
from __future__ import absolute_import, division, print_function
from LauncherPlugin.Rib import registerAgent

def Plugin( context ):
   # Rip should run only when the device is in multi-agent mode
   runnability = ( { "qualPath":
                     "cell/%cellId/routing/defaultVrfProtocolLaunch/Rip" }, )

   # Register Main Rip ( BR )
   registerAgent( context, "Rip", runnability, [] )

   # Vrf Rip ( VR ) is always conditional on the existence of vrf status
   vrfRunnability = \
      ( { "qualPath": "cell/%cellId/routing/RipVrfLaunchIndicator/%sliceId" }, )
   argv = ( "--z", "'client vrfname %(sliceId)s ns-name ns-%(sliceId)s'",
            "--sliceId=%(sliceId)s" )
   registerAgent( context, "Rip-vrf", vrfRunnability, argv,
                  exeName="/usr/bin/Rip-vrf" )
