#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pkgdeps:import LauncherContext

def Plugin( context ):
   rpkiConfig = {
         'qualPath': 'routing/rpki/cache/config.cacheConfig/%*'
   }
   rpkiStatus = {
         'qualPath': 'cell/%cellId/routing/rpki/cache/status.cacheStatus/%*'
   }
   multiAgentMode = {
         'qualPath': 'cell/%cellId/routing/defaultVrfProtocolLaunch/Bgp'
   }

   # runnability :  ( ( rpkiConfig AND multiAgentMode ) OR rpkiStatus )
   agentCfg = {
         'name': 'Rpki',
         'exe': '/usr/bin/Rpki',
         'argv': [],
         'heartbeatPeriod': 30,
         'runnability': [ ( rpkiConfig, multiAgentMode ), rpkiStatus ]
   }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
