#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from FlowTrackerCliUtil import (
   getSampledFlowTrackingCliConfigPath,
   getHardwareFlowTrackingCliConfigPath,
)
# pkgdeps: import LauncherContext

def Plugin( context ):
   # SftAgent runs if
   # 1) Sflow Agent is not running/configured and
   # 2) flow-tracking is enabled and
   # 3) HwFlowTracking is disabled and
   # 4) HwFlowTracking agent is not running and
   # 5) FlowWatcher is not running/configured and
   # 6) if int-agent is running, wait for its clean shutdown
   # 7) hardware flow-tracking capabilities is supported
   # (i.e. wait for "inbandTelemetry" qualPath check to fail)
   # or
   # Sft agent is running (during cleanup).

   sflowConfig = context.lookup( "sflow/config" )
   sflowStatus = context.lookup( "sflow/status" )
   sftConfig = context.lookup( getSampledFlowTrackingCliConfigPath() )
   hwFtConfig = context.lookup( getHardwareFlowTrackingCliConfigPath() )
   fwConfig = context.lookup( "flowwatcher/config" )
   fwLauncherPath = "cell/%cellId/flowwatcher/launcherConfig/FlowWatcher"
   capabilities = context.lookup( 'hardware/flowtracking/capabilities/sampled' )
   sftLauncherPath = 'flowtracking/activeAgent/sft'
   hwFtLauncherPath = 'flowtracking/activeAgent/hwAccel'
   intLauncherPath = 'flowtracking/activeAgent/inbandTelemetry'
   postcardLauncherPath = 'postcardtelemetry/activeAgent/postcardTelemetry'
   agentName = 'SftAgent'
   runnability = [
      (
         { 'entity' : sflowConfig, 'qualAttr' : 'enabled', 'negate' : True,
           'readableText' : 'sFlow feature is disabled' },
         { 'entity' : sflowStatus, 'qualAttr' : 'active', 'negate' : True,
           'readableText' : 'Sflow agent is not running' },
         { 'entity' : hwFtConfig, 'qualAttr' : 'enabled', 'negate' : True,
           'readableText' : 'hardware flow tracking feature is disabled' },
         { 'entity' : fwConfig, 'qualAttr' : 'enabled', 'negate' : True,
           'readableText' : 'monitor security awake feature is disabled' },
         { 'entity' : sftConfig, 'qualAttr' : 'enabled',
           'readableText' : 'sampled flow tracking feature is enabled' },
         { 'entity' : capabilities, 'qualAttr' : 'supported',
           'readableText' : 'hardware supports sampled flow tracking feature' },
         { 'qualPath' : fwLauncherPath, 'negate' : True,
           'readableText' : 'FlowWatcher agent is not running' },
         { 'qualPath' : hwFtLauncherPath, 'negate' : True,
           'readableText' : 'hardware flow tracking is not active' },
         { 'qualPath' : intLauncherPath, 'negate' : True,
           'readableText' : 'InbandTelemetry agent is not running' },
         { 'qualPath' : postcardLauncherPath, 'negate' : True,
           'readableText' : 'PostcardTelemetry agent is not running' },
      ),
      { 'qualPath' : sftLauncherPath, 'readableText' : 'SftAgent is active' },
   ]
   agentCfg = { 'name' : agentName,
                'exe' : '/usr/bin/SftAgent',
                'argv' : [],
                'heartbeatPeriod' : 90,
                'runnability' : runnability }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
