# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pkgdeps : import LauncherContext


def Plugin( context ):

   roleName = context.allSupervisorsRoleName
   agentName = "SbfdReflector"
   exeName = "/usr/bin/SbfdReflector"

   configEnt = context.lookup( 'bfd/config/global' )
   sbfdReflectorConfigured = { "entity": configEnt,
                               "qualAttr": "sbfdReflectorLocalDisc" }
   runnability = [ sbfdReflectorConfigured ]

   agentCfg = { "name": agentName,
                "exe": exeName,
                "argv": [],
                "heartbeatPeriod": 30,
                "runnability": runnability,
              }

   roleName = { 'sso': context.allSupervisorsRoleName,
                'rpr': context.activeSupervisorRoleName }
   context.agentConfigIs( roleName, agentCfg )
