#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   agentName = 'SflowAccel'

   # -------------------------------------------------------------------------
   # SflowAccel agent runs on the active supervisor when at least one compatible
   # linecard is present in the system.
   # -------------------------------------------------------------------------
   sflowAccelRunnability = context.lookup( 'hardware/sflowAccel/runnability' )
   sflowAccelStatus = context.lookup( 'hardware/sflowAccel/status/fpga' )

   runnability = [
     { "entity" : sflowAccelRunnability,
       "qualAttr" : "sflowAccelRunnable" },
     { "entity" : sflowAccelStatus,
       "qualAttr" : "running" },
   ]
   sflowAccelAgentCfg = {
      'name' : agentName,
      'exe' : '/usr/bin/SflowAccel',
      'argv' : [],
      'heartbeatPeriod' : 30,
      'startupGracePeriod' : 30,
      'runnability' : runnability
   }

   role = context.activeSupervisorRoleName

   context.agentConfigIs( role, sflowAccelAgentCfg )
