#!/usr/bin/env python3
# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# This generates a dependency on Launcher
# pkgdeps: import LauncherContext
import Swag

def Plugin( context ):

   if not Swag.isSupervisor():
      return

   agentName = 'SwagSystem'
   agentCfg = { 'name': agentName,
                'exe': '/usr/bin/SwagSystem',
                'argv': [],
                'heartbeatPeriod': 30,
                "runnability": [
                   { "qualPath": "swag/status.member/%*" }
                ]
              }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
