#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   agentName = 'TwampControl'
   controlConfig = context.lookup( 'connectivityMonitor/twamp/control/config' )
   # Control agent will be started once the user invokes 'TWAMP server' in the CLI
   agentCfg = { 'name': agentName,
                'exe': '/usr/bin/TwampControl',
                'argv': [],
                'heartbeatPeriod': 30,
                'runnability': [ { 'entity': controlConfig,
                                   'qualAttr': 'enabled' } ]
   }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
