# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   config = context.lookup( 'mgmt/virtualnetwork/config' )
   status = context.lookup( 'mgmt/virtualnetwork/status' )
   controllerdbStatus = context.lookup( 'controller/status' )
   defaultClusterStatus = context.lookup(
      "controller/cluster/statusDir.status/default" )
   openstackStatus = context.lookup( 'mgmt/openstack/status' )

   agentName = 'VirtualNetwork'
   agentRunnability = [ ( { 'entity': config,
                            'qualAttr': 'enabled' },
                          { 'entity': controllerdbStatus,
                            'qualAttr': 'enabled' },
                          # The status of any new client of VirtualNework should be
                          # OR'd with openstackStatus
                          { 'entity': openstackStatus,
                            'qualAttr': 'enabled' },
                          { 'entity': defaultClusterStatus,
                            'qualAttr': 'isStandaloneOrLeader' } ),
                        { 'entity': status,
                          'qualAttr': 'enabled' },
                      ]
   agentCfg = { 'name': agentName,
                'exe': '/usr/bin/VirtualNetwork',
                'argv': [],
                'heartbeatPeriod': 30,
                'runnability': agentRunnability }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
