#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):

   roleName = context.activeSupervisorRoleName
   agentName = "VmTracer"
   agentCfg = { "name": agentName,
                "exe": "/usr/bin/VmTracer",
                "argv": [ '--sliceId=%(sliceId)s' ],
                "heartbeatPeriod": 60,
                "runnability": [ { "qualPath": "vmtracer/slice/enable/%sliceId" },
                                 { "qualPath": "vmtracer/slice/running/%sliceId" } ]
              }

   context.agentConfigIs( roleName, agentCfg )
