# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   runnabilityEnt = context.lookup( 'hardware/xcvr/central/config' )
   agentCfg = {
     "name": "XcvrCentralAgent",
     "exe": "/usr/bin/XcvrCentralAgent",
     "argv": [],
     "heartbeatPeriod": 30,
     "runnability": [ { 'entity': runnabilityEnt,
                        'qualAttr': 'agentRunnable' } ]
   }
   role = context.activeSupervisorRoleName
   context.agentConfigIs( role, agentCfg )
