#!/usr/bin/env python3
# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Contains all the Python types required for use across the Launcher package to avoid
# redefinition in several places. This file leverages TacLazyType so types can be
# imported from this file outside of a TYPE_CHECKING check without incurring a
# runtime penalty.
#
# Note that some very specific types that don't need to be shared remain in the file
# that needs them.

from typing import Iterable, Union, TypedDict
from TypeFuture import TacLazyType

# TAC types used in type annotations (alphabetized by type name)

AgentConfig = TacLazyType( 'Launcher::AgentConfig' )
AgentConfigDir = TacLazyType( 'Launcher::AgentConfigDir' )
AgentShutdownConfig = TacLazyType( 'Launcher::AgentShutdownConfig' )
AgentShutdownConfigDir = TacLazyType( 'Launcher::AgentShutdownConfigDir' )
AgentStatus = TacLazyType( 'Launcher::AgentStatus' )
AgentStatusDir = TacLazyType( 'Launcher::AgentStatusDir' )
AgentValgrindConfig = TacLazyType( 'Launcher::AgentValgrindConfig' )
AgentValgrindConfigDir = TacLazyType( 'Launcher::AgentValgrindConfigDir' )
CellInstanceIndex = TacLazyType( 'Launcher::CellInstanceIndex' )
LaunchAgentRequest = TacLazyType( 'Launcher::LaunchAgentRequest' )
LaunchAgentRequestDir = TacLazyType( 'Launcher::LaunchAgentRequestDir' )
LaunchCandidateDir = TacLazyType( 'Launcher::LaunchCandidateDir' )
ProcLauncherStatus = TacLazyType( 'Launcher::ProcLauncherStatus' )
ProcMgrSyncRequest = TacLazyType( 'Launcher::ProcMgrSyncRequest' )
ProcMgrSyncRequestDir = TacLazyType( 'Launcher::ProcMgrSyncRequestDir' )
Runnability = TacLazyType( 'Launcher::Runnability' )
UserDaemonAccessToken = TacLazyType( 'Launcher::UserDaemonAccessToken' )

LowMemoryModeConfig = TacLazyType( 'ProcMgr::LowMemoryModeConfig' )
LowMemoryModeRequest = TacLazyType( 'ProcMgr::LowMemoryModeRequest' )
LowMemoryModeStatus = TacLazyType( 'ProcMgr::LowMemoryModeStatus' )

RedundancyMode = TacLazyType( 'Redundancy::RedundancyMode' )
RedundancyProtocol = TacLazyType( 'Redundancy::RedundancyProtocol' )
RedundancyRoleName = TacLazyType( 'Redundancy::RedundancyRoleName' )
RedundancyStatus = TacLazyType( 'Redundancy::RedundancyStatus' )

StageAgentStatus = TacLazyType( 'Stage::AgentStatus' )
CompletionStatusDir = TacLazyType( 'Stage::CompletionStatusDir' )
EnabledConfig = TacLazyType( 'Stage::EnabledConfig' )
FatalError = TacLazyType( 'Stage::FatalError' )
ProgressDir = TacLazyType( 'Stage::ProgressDir' )

SwagRunnabilityFilter = TacLazyType( 'Launcher::SwagRunnabilityFilter' )
MemberId = TacLazyType( 'Swag::MemberId' )
SliceToMemberMapDir = TacLazyType( 'Swag::SliceToMemberMapDir' )
SwagStatus = TacLazyType( 'Swag::SwagStatus' )

Dir = TacLazyType( 'Tac::Dir' )
Entry = TacLazyType( 'Tac::Dir::Entry' )
Entity = TacLazyType( 'Tac::Entity' )
LogManager = TacLazyType( 'Tac::LogManager' )

# Launcher non-class Python types

class QualPath( TypedDict, total=False ):
   qualPath: str
   negate: bool

class QualAttr( TypedDict, total=False ):
   entity: str
   qualAttr: str
   negate: bool

PyRunnability = Union[ QualPath,
                       QualAttr,
                       list[ 'PyRunnability' ],
                       tuple[ 'PyRunnability', ... ] ]

# Python dict representing a Launcher::AgentConfig. Note that total=False means
# that not every key in this TypedDict must be present
class AgentCfgDict( TypedDict, total=False ):
   name: str
   launchName: str
   exe: str
   argv: list[ str ]
   heartbeatPeriod: int
   startupGracePeriod: int
   coredumpTimeout: int
   swagRunnabilityFilter: Iterable[ SwagRunnabilityFilter ]
   runnability: PyRunnability
   oomScoreAdj: int
   latencySensitive: bool
   rssLimitBytes: int
   restartWindow: int
   oneTimeLaunch: bool

RoleStrOrDict = Union[ RedundancyRoleName, str,
                       dict[ Union[ RedundancyProtocol, str ],
                             Union[ RedundancyRoleName, str ] ] ]
