# Copyright (c) 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import re
from Toggles import LldpToggleLib

class EnabledTlvsFlags:
   """
   PortConfig::EnabledTlvs flag values
   """

   portDesc = 1
   sysName = 2
   sysDesc = 4
   sysCap = 8

class Dot1EnabledTlvsFlags:
   """
   PortConfig::Dot1EnabledTlvs flag values
   """

   mgmtAddrTx = 1
   portVlanTx = 2
   vlanNameTx = 4
   linkAggregation = 8

class Dot3EnabledTlvsFlags:
   """
   PortConfig::Dot3EnabledTlvs flag values
   """

   macPhyConfigStatus = 1
   powerViaMdi = 2
   linkAggregation = 4
   maxFrameSize = 8

defaultAdminStatus = 'txAndRx'

# All TLVs disabled by default (keywords)
defaultDisabledTlvs = ( 'vlan-name', 'link-aggregation-ieee802.1' )

tlvKeywordToAttrNameMap = {
   'port-description' : 'portDescTlvEnabled',
   'system-name' : 'sysNameTlvEnabled',
   'system-description' : 'sysDescTlvEnabled',
   'system-capabilities' : 'sysCapTlvEnabled',
   'management-address' : 'mgmtAddrTlvEnabled',
   'port-vlan' : 'portVlanIdTlvEnabled',
   'link-aggregation-ieee802.1' : 'linkAggregation8021TlvEnabled',
   'link-aggregation' : 'linkAggregation8023TlvEnabled',
   'max-frame-size' : 'maxFrameSizeTlvEnabled',
   'power-via-mdi' : 'powerViaMdiTlvEnabled',
   'vlan-name' : 'vlanNameTlvEnabled',
}

tlvKeywordToValueAttrMap = {
   'system-name' : 'sysNameTlv',
   'system-description' : 'sysDescTlv',
}

chassisIdSubtypeValues = {
   'cidReserved' : 0,
   'cidChassisComponent' : 1,
   'cidInterfaceAlias' : 2,
   'cidPortComponent' : 3,
   'cidMacAddress' : 4,
   'cidNetworkAddress' : 5,
   'cidInterfaceName' : 6,
   'cidLocal' : 7,
   'cidUnknown' : 8,
}

def chassisIdSubtypeToValue( subtype ):
   value = chassisIdSubtypeValues.get( subtype )
   if value is None:
      m = re.match( r'Lldp::ChassisIdSubtype\((\d+)\)$', subtype )
      value = int( m.group( 1 ) )
   assert 0 <= value <= 255
   return value

portIdSubtypeValues = {
   'pidReserved' : 0,
   'pidInterfaceAlias' : 1,
   'pidPortComponent' : 2,
   'pidMacAddress' : 3,
   'pidNetworkAddress' : 4,
   'pidInterfaceName' : 5,
   'pidAgentCircuitId': 6,
   'pidLocal' : 7,
   'pidUnknown' : 8,
}

def portIdSubtypeToValue( subtype ):
   value = portIdSubtypeValues.get( subtype )
   if value is None:
      m = re.match( r'Lldp::PortIdSubtype\((\d+)\)$', subtype )
      value = int( m.group( 1 ) )
   assert 0 <= value <= 255
   return value

ifSubtypeValues = {
   'unknown' : 1,
   'ifIndex' : 2,
   'systemPortNumber' : 3,
}

def ifSubtypeToValue( subtype ):
   value = ifSubtypeValues.get( subtype )
   if value is None:
      m = re.match( r'Lldp::ManAddrIfSubtype\((\d+)\)$', subtype )
      value = int( m.group( 1 ) )
   return value

def getMedAttrMap():
   medTlvKeywordToAttrNameMap = {
   'network-policy' : 'medNetworkPolicyTlvEnabled',
   }
   if LldpToggleLib.toggleLldpSerialNumberTlvEnabled():
      medTlvKeywordToAttrNameMap.update(
         { 'serial-number' : 'medSerialNumberTlvEnabled' } )

   return medTlvKeywordToAttrNameMap
