#!/usr/bin/env python3

# Copyright (c) 2024 Arista Networks, Inc. All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Agent
import Tac
import Tracing

from LogArchiverAgentLib.ArchiveChecker import runArchiveCheck

__defaultTraceHandle__ = Tracing.Handle( "LogArchiverAgent" )
t0 = Tracing.trace0

# using a constant here, make it a configurable value in the future
ARCHIVE_INTERVAL = 60

class LogArchiverAgent( Agent.Agent ):

   def __init__( self, entityManager ):
      super().__init__( entityManager, agentName="LogArchiverAgent" )
      self.configEntity = None
      self.clockNotifie = None
      # for testing purpose only
      self.counter = 0

   def runArchive( self ):
      t0( "calling into runArchiveCheck" )
      runArchiveCheck( runInAgent=True )
      self.counter += 1
      self.clockNotifie = Tac.ClockNotifiee( handler=self.runArchive,
                                          timeMin=Tac.now() + ARCHIVE_INTERVAL )

   def doInit( self, entityManager ):
      t0( "doInit" )
      mg = entityManager.mountGroup()
      entityDict = mg.mountAll( "LogArchiverAgent" )
      self.configEntity = entityDict[ "mgmt/archive/config" ]

      def _finish():
         self.clockNotifie = Tac.ClockNotifiee( handler=self.runArchive,
                                               timeMin=0 )
         t0( "mounts completed" )

      mg.close( _finish )

if __name__ == "__main__":
   container = Agent.AgentContainer( [ LogArchiverAgent ] )
   container.runAgents()
