# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from Ark import ReversibleDict
import Tac

# Cli cipher to Tac cipher suite
cliToTacCipherSuite = ReversibleDict ( { 
   "aes128-gcm-xpn" : 'gcmAesXpn128',
   "aes256-gcm-xpn" : 'gcmAesXpn256',
   "aes128-gcm" : 'gcmAes128',
   "aes256-gcm" : 'gcmAes256'
} )

# Tac cipher suite to cli cipher
tacCipherSuiteToCli = cliToTacCipherSuite.reverse()

trafficPolicyOnNoMkaToCli = ReversibleDict( {
   'useActiveSak' : 'allow active-sak',
   'unprotected' : 'allow',
   'blocked' : 'drop'
} )

cliToTrafficPolicyOnNoMka = trafficPolicyOnNoMkaToCli.reverse()

intfTrafficStatus = ReversibleDict ( {
   'Protected' : 'encrypted',
   'Unprotected' : 'unencrypted',
   'None' : 'blocked'
} )

def trafficStatus( cpStatus ):
   if not cpStatus.controlledPortEnabled:
      return "trafficBlocked"
   else:      
      if cpStatus.unprotectedTraffic:
         return "trafficUnprotected"
      else:
         return "trafficProtected"

# Macsec::PtpBypassSupport Enum values to show command output representation
ptpBypassSupportToCli = {
   'notSupported' : 'not supported',
   'multicast' : 'multicast',
   'unicast' : 'unicast',
   'controlPlane' : 'control-plane',
   'dataPlane' : 'data-plane',
   'full' : 'full',
}

def getPtpBypassesString( bypassesSupported ):
   bypassesStr = ""
   if bypassesSupported:
      bypassesSupportedCli = []
      for bypass in bypassesSupported:
         bypassesSupportedCli.append( ptpBypassSupportToCli[ bypass ] )
      bypassesSupportedCli.sort()

      # Create a string from the list of bypasses
      if len( bypassesSupportedCli ) == 1:
         bypassesStr = bypassesSupportedCli[ 0 ]
      else:
         bypassesStr = ", ".join( bypassesSupportedCli[ :-1 ] )
         bypassesStr += " and %s" % bypassesSupportedCli[ -1 ]
   return bypassesStr

# Gets the PTP bypass support string for 'show mac security ptp bypass'
def getMacSecPtpBypass( bypassesSupported ):
   PtpBypassSupport = Tac.Type( "Macsec::PtpBypassSupport" )
   bypassStr = ""
   if bypassesSupported:
      if PtpBypassSupport.full in bypassesSupported:
         bypassStr = ""
      elif PtpBypassSupport.notSupported in bypassesSupported:
         bypassStr = "No PTP bypass support"
      else:
         baseStr = "Only %s PTP packets will be bypassed"
         bypassStr = baseStr % getPtpBypassesString( bypassesSupported )
   else:
      bypassStr = "No PTP bypass support"
   return bypassStr

# Gets the PTP bypass support string for 'show mac security interface detail'
def getMacSecIntfDetailPtpBypass( bypassesSupported ):
   PtpBypassSupport = Tac.Type( "Macsec::PtpBypassSupport" )
   bypassStr = ""
   if bypassesSupported and PtpBypassSupport.notSupported not in bypassesSupported:
      if PtpBypassSupport.full in bypassesSupported:
         bypassStr = "Bypassing all PTP packets"
      else:
         baseStr = "Only bypassing %s PTP packets"
         bypassStr = baseStr % getPtpBypassesString( bypassesSupported )
   return bypassStr
