# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tracing
from TypeFuture import TacLazyType

traceHandle = Tracing.defaultTraceHandle()
t0 = traceHandle.trace0

MirroringConstants = TacLazyType( "Mirroring::Constants" )

def numOfSessionUsed( sess ):
   if not sess.greTunnelKey.dstIpGenAddr.isAddrZero and \
      not sess.dropGreTunnelKey.dstIpGenAddr.isAddrZero:
      return 2
   else:
      return 1

def numValidSessions( mirroringConfig ):
   numSessions = 0
   for sessToAdd, sessionCfg in mirroringConfig.session.items():
      if sessionCfg.srcIntf or sessionCfg.targetIntf:
         new = numOfSessionUsed( sessionCfg )
         numSessions += new
         # pylint: disable-next=consider-using-f-string
         t0( 'NumSessions for session {} is {} '.format( sessToAdd, new ) )
   return numSessions

def isMaxSessionsReached( mode, sessionToAdd, mirroringHwCapability, mirroringConfig,
                          src=False, forwardingDrop=False ):
   if mode.session_.startupConfig():
      # should not fail while loading the startup config since
      # the maxSessions will probably not be set yet
      return False
   maxSessions = mirroringHwCapability.maxSupportedSessions
   numSessions = numValidSessions( mirroringConfig )
   if sessionToAdd in mirroringConfig.session:
      sess = mirroringConfig.session[ sessionToAdd ]
      if not sess.srcIntf and not sess.targetIntf:
         # if gre tunnels are set
         new = numOfSessionUsed( sess )
         numSessions += new
         # pylint: disable-next=consider-using-f-string
         t0( 'NumSessions for session {} is {} '.format( sessionToAdd, new ) )
      elif ( not src and
            ( sess.greTunnelKey.dstIpGenAddr.isAddrZero or
              sess.dropGreTunnelKey.dstIpGenAddr.isAddrZero ) and
            ( ( not sess.greTunnelKey.dstIpGenAddr.isAddrZero and forwardingDrop ) or
              ( not sess.dropGreTunnelKey.dstIpGenAddr.isAddrZero and
                not forwardingDrop ) ) ):
         # this is for a session that either only had a normal gre tunnel
         # and is getting a forwarding drop tunnel added as well or vice versa,
         # only one tunnel would have been counted for such a session before
         if forwardingDrop:
            # pylint: disable-next=consider-using-f-string
            t0( 'Adding forwarding drop extra sess for session {} '.format(
               sessionToAdd ) )
         else:
            # pylint: disable-next=consider-using-f-string
            t0( 'Adding gre tunnel extra sess for session {} '.format(
               sessionToAdd ) )
         numSessions += 1
      else:
         # not adding any new config changing session allocation here
         t0( 'Not adding a new session' )
         return False
   else:
      numSessions += 1
   # pylint: disable-next=consider-using-f-string
   t0( 'Total sessions {} maxSessions {}'.format( numSessions, maxSessions ) )
   return numSessions > maxSessions


