#!/usr/bin/env python3
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
from IpLibConsts import DEFAULT_VRF
from Arnet import IpGenAddr

mirroringConfigSysdbPath = 'mirroring/config'
mirroringHwCapabilitySysdbPath = 'mirroring/hwcapability'

MetadataElementType = Tac.Type( 'Mirroring::MetadataElementType' )
GreTunnelKey = Tac.Type( "Mirroring::GreTunnelKey" )
VxlanTunnelKey = Tac.Type( "Mirroring::VxlanTunnelKey" )

def OperStateType():
   return Tac.Type( "Mirroring::OperState" )

tokenMetadataElementDict = {
   'ingress-vlan' : MetadataElementType.ingressVlan,
   'egress-port'  : MetadataElementType.egressPort,
   'ingress-port' : MetadataElementType.ingressPort
}

metadataElementTokenDict = {
   MetadataElementType.ingressVlan : 'ingress-vlan',
   MetadataElementType.egressPort  : 'egress-port',
   MetadataElementType.ingressPort : 'ingress-port',
}

def createGreTunnelKey( srcIp, destIp, ttl, dscp,
                        greHdrProto=GreTunnelKey.defaultGreHdrProto,
                        forwardingDrop=False, vrf=DEFAULT_VRF, keyConfigured=False,
                        key=0, sessionName='' ):
   assert isinstance( srcIp, str ) == isinstance( destIp, str )
   if isinstance( srcIp, str ):
      return GreTunnelKey( IpGenAddr( srcIp ), IpGenAddr( destIp ), ttl, dscp,
                           greHdrProto, forwardingDrop, vrf, keyConfigured, key,
                           sessionName )
   else:
      return GreTunnelKey( srcIp, destIp, ttl, dscp, greHdrProto, forwardingDrop,
                           vrf, keyConfigured, key, sessionName )

def createVxlanTunnelKey( vti, vlan, localVtepIp, remoteVtepIp, udpPort, vni,
                          ttl, dscp, vrf=DEFAULT_VRF ):
   if isinstance( localVtepIp, str ):
      localVtepIp = IpGenAddr( localVtepIp )
   if isinstance( remoteVtepIp, str ):
      remoteVtepIp = IpGenAddr( remoteVtepIp )
   return VxlanTunnelKey( vti, vlan, localVtepIp, remoteVtepIp, udpPort, vni, ttl,
                          dscp, vrf )

def createV4ZeroGreTunnelKey():
   return createGreTunnelKey( '0.0.0.0', '0.0.0.0', 0, 0, 0 )

def createV6ZeroGreTunnelKey():
   return createGreTunnelKey( '::', '::', 0, 0, 0 )

def updateVxlanTunnelKey( oldKey, **kwargs ):
   return Tac.newInstance( "Mirroring::VxlanTunnelKey",
      kwargs.get( 'vti', oldKey.vti ),
      kwargs.get( 'vlan', oldKey.vlan ),
      kwargs.get( 'localVtepIp', oldKey.localVtepIp ),
      kwargs.get( 'remoteVtepIp', oldKey.remoteVtepIp ),
      kwargs.get( 'udpPort', oldKey.udpPort ),
      kwargs.get( 'vni', oldKey.vni ),
      kwargs.get( 'ttl', oldKey.ttl ),
      kwargs.get( 'dscp', oldKey.dscp ),
      kwargs.get( 'vrf', oldKey.vrf ) )

