#!/usr/bin/env python3
# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import MlagMountHelper
from MlagShared import configCheckDir as CCD
import Tracing
Tracing.Handle( "MlagConfigCheckPlugin::Fhrp" )
t2 = Tracing.trace2

fhrpConfig = None
varpConfig = None

def Plugin( ctx ):
   fhrpDir = ctx.configCheckP2pDir.newEntity( 'Tac::Dir', 'routing' )
   p2pVarpConfig = fhrpDir.newEntity( "MlagP2p::ConfigCheck::GenericConfig",
                                               "routingConfig" )
   smContainer = \
         ctx.configCheckDir.newEntity( 'Mlag::ConfigCheck::SmContainer',
                                       'RoutingConfigCheckSm' )
   # Mount from sysdb.
   mg = ctx.entityManager.mountGroup()
   mg.mount( 'routing/fhrp/config', 'Routing::Fhrp::Config', 'r' )
   mg.mount( 'routing/fhrp/varp/config', 'Routing::Fhrp::VarpConfig', 'r' )
   varpConfigCheckDesc = \
         ctx.configCheckDir.newEntity( 'Mlag::ConfigCheck::ConfigCheckDesc',
                                       'Routing' )
   varpConfigCheckDesc.attrName[ 'virtualMacWithMask' ] = \
      'virtual-router mac-address'

   # Mount mlag/config, Mlag::Config and its dependent paths
   mlagConfig = MlagMountHelper.mountMlagConfig( mg )
   mlagStatus = MlagMountHelper.mountMlagStatus( mg )

   def peerRoot():
      return ctx.mountStatus.peerRoot

   def activeSupervisor():
      return ctx.agent.runMode == 'mlagActive'

   def handleActive( mlagState, failover ):
      if activeSupervisor() and peerRoot():
         try:
            configCheckDir = CCD( peerRoot() )
            peerVarpConfig = configCheckDir[ 'routing' ].entity[ 'routingConfig' ]
         except KeyError:
            return
         if smContainer.configCheckSm:
            if mlagState == 'primary' and failover:
               varpConfigCheckCleanup()
         else:
            varpConfigCheck = ctx.configCheckPlugin( "routing" )
            smContainer.configCheckSm = ( varpConfigCheck,
                                          'Routing',
                                          varpConfig,
                                          p2pVarpConfig,
                                          peerVarpConfig,
                                          varpConfigCheckDesc,
                                          mlagConfig, mlagStatus )
      elif not peerRoot():
         t2( "Deleting configCheckSm because peerRoot is None" )
         varpConfigCheckCleanup()

   def varpConfigCheckCleanup():
      smContainer.configCheckSm = None
      if activeSupervisor():
         ctx.configCheckPluginDel( "routing" )

   def handleInactive():
      t2( "handle mlag state Inactive in BridgingConfigCheck" )
      varpConfigCheckCleanup()

   def finishMounts():
      t2( "Mounts complete" )
      global fhrpConfig
      global varpConfig
      fhrpConfig = ctx.entityManager.entity( 'routing/fhrp/config' )
      varpConfig = ctx.entityManager.entity( 'routing/fhrp/varp/config' )

      def handleMlagStateForBridgingConfigCheck( mlagState, failover ):
         t2( "mlagState:", mlagState )

         if mlagState in ( "primary", "secondary" ):
            handleActive( mlagState, failover )
         else:
            handleInactive()
      ctx.callbackIs( handleMlagStateForBridgingConfigCheck )

   mg.close( finishMounts )
