#!/usr/bin/env python3
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import MlagMountHelper
from MlagShared import configCheckDir as CCD
import Tracing
from Toggles.StpToggleLib import toggleStpPriorityConfigSanityEnabled
t2 = Tracing.trace2

# subdirDeprecated collection is being deprecated from EOS.
# To be compatible with past/future releases, follow these
# recommendations:
# Do not introduce any new calls to newSubdirDeprecated
# i.e call newEntity to create an entity
# rather than a subdir.
# If looking up a subdir, first look in entityPtr collection
# if the key is not found, look in subdirDeprecated collection
# See AID/7616 for more details

def Plugin( ctx ):
   # Create local directories to be shared with peer.
   # subdirDeprecated collection is being deprecated from EOS.
   # do not introduce new calls to newSubdirDeprecated,
   # use newEntity to create an entity instead.
   # see message on top of this file regarding subdirDeprecated
   # lookup/creation.
   stpDir = ctx.configCheckP2pDir.newSubdirDeprecated( 'stp' )
   p2pStpConfig = stpDir.newEntity( "MlagP2p::ConfigCheck::GenericConfig",
                                    "config" )
   smContainer = ctx.configCheckDir.newEntity( 'Mlag::ConfigCheck::SmContainer',
                                               'StpConfigCheckSm')

   # Mount from sysdb.
   mg = ctx.entityManager.mountGroup()
   stpInputConfig = mg.mount( 'stp/input/config/cli',
                              'Stp::Input::Config', 'r')

   # Mount mlag/config, Mlag::Config and its dependent paths
   mlagConfig = MlagMountHelper.mountMlagConfig( mg )
   mlagStatus = MlagMountHelper.mountMlagStatus( mg )
   configCheckDesc = \
       ctx.configCheckDir.newEntity( 'Mlag::ConfigCheck::ConfigCheckDesc',
                                     'Stp')
   configCheckDesc.attrName['forceProtocolVersion' ] = 'mode'
   configCheckDesc.valueStrOverride['rapidPvstp'] = 'rapid-pvst'
   configCheckDesc.attrName['bridgeForwardDelay' ] = 'forward-time'
   configCheckDesc.attrName['bridgeHelloTime'] = 'hello-time'
   configCheckDesc.attrName['maxAge'] = 'max-age'
   configCheckDesc.attrName['maxHops'] = 'max-hops'
   configCheckDesc.attrName['loopGuardEnabled'] = 'loopguard'
   configCheckDesc.attrName['portChannelGuardEnabled'] = 'portchannel guard'
   configCheckDesc.attrName['rateLimitInterval'] = 'bpduguard rate-limit interval'
   configCheckDesc.attrName['bridgeAssurance'] = 'bridge assurance'
   configCheckDesc.attrName['txHoldCount'] = 'transmit hold-count'
   configCheckDesc.attrName['portfastBpduguard'] = 'portfast bpduguard'
   configCheckDesc.attrName['portfastBpdufilter'] = 'portfast bpdufilter'
   configCheckDesc.attrName['mstPvstBorder'] = 'mst pvst border'
   configCheckDesc.attrName[ 'superRoot' ] = 'root super'
   configCheckDesc.attrName['mismatchedBpduMode'] = 'vlan-mismatched pvst bpdu mode'
   # mstConfigSpec expands to the attributes 'mst-instance%d', 'mst-region-name',
   # and 'mst-revision-number'
   ### mstConfigSpec is disabled for the near future due to an ISSU issue having to
   ### do with the size of the string generated for the mstConfigSpec
   # configCheckDesc.attrName[ 'mstConfigSpec' ] = 'mst-config-spec'

   configCheckDesc.collectionName['disabledVlan'] = 'disabled-vlan'

   portConfigEntT = configCheckDesc.newNestedConfigCheckDesc('portConfig')
   portConfigEntT.mlagInterfacesOnly = True
   # stp creates a portConfig entity in /ar/sysdb/stp/input/cli/config when any
   # attribute value is changed to a non-default value. However, after this, even
   # when all attributes are configured to default values, the entity remains.  It is
   # possible that for both mlag peers, the values are default, but one has an entity
   # created for it and other does not. This will create an inconsistency for mlag
   # config check purposes. 
   portConfigEntT.absenceImpliesDefaultVal = True
   portConfigEntT.attrName['portPriority'] = 'port-priority' 
   portConfigEntT.attrName['adminPointToPointMac'] = 'link-type'
   portConfigEntT.attrName['acceptTaggedPdu'] = 'accept taggedPdu'
   portConfigEntT.attrName['allowedTag'] = 'allowed-tag'
   portConfigEntT.attrName['adminEdgePort'] = 'portfast-admin'
   portConfigEntT.attrName['autoEdgePort'] = 'portfast-auto'
   portConfigEntT.attrName['networkPort'] = 'portfast-network'
   portConfigEntT.attrName['bpduguard'] = 'bpduguard'
   portConfigEntT.attrName['guard'] = 'guard'
   portConfigEntT.attrName['rateLimitEnabled'] = 'bpduguard rate-limit'
   portConfigEntT.attrName['bpdufilter'] = 'bpdufilter'
   # provide default values for the interface ( since absenceImpliesDefaultVal )
   portConfigEntT.defaultVal['portPriority'] = '128' 
   portConfigEntT.defaultVal['adminPointToPointMac'] = '\'autoDetect\''
   portConfigEntT.defaultVal['acceptTaggedPdu'] = 'False'
   portConfigEntT.defaultVal['allowedTag'] = '0'
   portConfigEntT.defaultVal['adminEdgePort'] = 'False'
   portConfigEntT.defaultVal['autoEdgePort'] = 'True'
   portConfigEntT.defaultVal['networkPort'] = 'False'
   portConfigEntT.defaultVal['bpduguard'] = '\'bpduguardDefault\''
   portConfigEntT.defaultVal['guard'] = '\'guardDefault\''
   portConfigEntT.defaultVal['rateLimitEnabled'] = '\'rateLimitDefault\''
   portConfigEntT.defaultVal['bpdufilter'] = '\'bpdufilterDefault\''

   if toggleStpPriorityConfigSanityEnabled():
      configCheckDesc.attrName[ 'dummyAttrstpiConfig' ] = 'dummyAttrstpiConfig'
      configCheckDesc.defaultVal[ 'dummyAttrstpiConfig' ] = 'False'
      stpiConfigEntT = configCheckDesc.newNestedConfigCheckDesc( 'stpiConfig' )
      mstiConfigEntT = stpiConfigEntT.newNestedConfigCheckDesc( 'mstiConfig' )
      mstiConfigEntT.absenceImpliesDefaultVal = True
      mstiConfigEntT.attrName[ 'bridgePriority' ] = 'priority'
      mstiConfigEntT.defaultVal[ 'bridgePriority' ] = '32768'

   def peerRoot():
      return ctx.mountStatus.peerRoot

   def activeSupervisor():
      return ctx.agent.runMode == 'mlagActive'

   def handleActive( mlagState, failover ):
      if activeSupervisor() and peerRoot():
         try:
            configCheckDir = CCD( peerRoot() )
            stpConfigDir = None
            # subdirDeprecated collection is being deprecated from EOS.
            # to be compatible with past/future releases 
            # first look up in default collection ( entityPtr )
            # see message on top of this file regarding subdirDeprecated
            # lookup/creation.
            if configCheckDir.get( 'stp' ):
               stpConfigDir = configCheckDir['stp']
            else:
               # lookup in subdirDeprecated collection
               stpConfigDir = configCheckDir.subdirDeprecated['stp']
            peerStpConfig = stpConfigDir.entity['config']
         except KeyError:
            # This is an ISSU case. We will not have a configChecker for Stp.
            return
         if smContainer.configCheckSm:
            if mlagState == 'primary':
               if failover:
                  stpConfigCheckCleanup()
         else:
            configCheck = ctx.configCheckPlugin( "stp" )
            smContainer.configCheckSm = ( configCheck, 'Stp', 
                                          stpInputConfig, p2pStpConfig,
                                          peerStpConfig, configCheckDesc,
                                          mlagConfig, mlagStatus )
      elif not peerRoot():
         t2( "Deleting configcheckSm because peerRoot is none" )
         stpConfigCheckCleanup()

   def stpConfigCheckCleanup():
      smContainer.configCheckSm = None
      if activeSupervisor():
         ctx.configCheckPluginDel( "stp" )

   def handleInactive():
      t2( "handle mlag state Inactive in StpConfigCheck" )
      stpConfigCheckCleanup()

   def finishMounts():
      t2( "MlagConfigCheck Mounts complete" )
      def handleMlagStateForStpConfigCheck( mlagState, failover ):
         t2( "MlagConfigCheck mlagState:", mlagState )

         if mlagState in ("primary", "secondary"):
            handleActive( mlagState, failover )
         else:
            handleInactive()
      ctx.callbackIs( handleMlagStateForStpConfigCheck )

   mg.close( finishMounts )
