# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BothTrace
import Tac

BothTrace.initialize( 'qt-out-%d.qt' )
bv = BothTrace.Var
bt2 = BothTrace.trace2

# subdirDeprecated collection is being deprecated from EOS.
# To be compatible with past/future releases, follow these
# recommendations:
# Do not introduce any new calls to newSubdirDeprecated
# i.e call newEntity to create an entity
# rather than a subdir.
# If looking up a subdir, first look in entityPtr collection
# if the key is not found, look in subdirDeprecated collection
# See AID/7616 for more details

def Plugin( ctx ):
   agent = ctx.agent

   # Create /ar/mlag/mlagDhcpRelay
   # subdirDeprecated collection is being deprecated from EOS.
   # do not introduce new calls to newSubdirDeprecated,
   # use newEntity to create an entity instead.
   # see message on top of this file regarding subdirDeprecated
   # lookup/creation.
   mlagDhcpRelayDir = agent.parent.newSubdirDeprecated( 'mlagDhcpRelay' )
   # Instantiate smContainer at /ar/mlag/DhcpRelay/mlagDhcpRelaySmContainer
   smC = mlagDhcpRelayDir.newEntity( 'MlagDhcpRelay::MlagSyncSmContainer',
                                     'mlagSyncSmContainer' )

   # Create p2p entities for export.
   dhcpRelayP2pDir = ctx.localDir.newSubdirDeprecated( 'dhcpRelay' )
   p2pLocalStatus = dhcpRelayP2pDir.newEntity(
         "MlagP2p::DhcpRelay::Status", "status" )

   # Mount local entities from Sysdb
   mg = ctx.entityManager.mountGroup()
   dhcpRelayStatusSysdb = mg.mount( 'ip/helper/dhcprelay/status',
         'Ip::Helper::DhcpRelay::Status', 'r' )
   # BUG483654: reacting to Config::intfConfig instead of ShadowConfig::intfConfig
   dhcpRelayConfigSysdb = mg.mount( 'ip/helper/dhcprelay/config',
         'Ip::Helper::DhcpRelay::Config', 'r' )
   dhcpRelayStatusMlagSysdb = mg.mount( 'ip/helper/dhcprelay/mlagStatus',
         'MlagDhcpRelay::Status', 'wc' )

   def peerRoot():
      return ctx.mountStatus.peerRoot

   def activeSupervisor():
      return ctx.agent.runMode == 'mlagActive'

   def handleActive( mlagState, failover ):
      bt2( 'handleActive called with state', bv( mlagState ), 'failover',
          bv( failover ) )
      if not smC.dhcpRelaySysdbToP2pSm:
         smC.dhcpRelaySysdbToP2pSm = ( dhcpRelayStatusSysdb,
                                       p2pLocalStatus,
                                       ctx.agent.scheduler )
         assert smC.dhcpRelaySysdbToP2pSm

      if not activeSupervisor():
         return

      if not smC.mlagDhcpRelayCleanupSm:
         smC.mlagDhcpRelayCleanupSm = ( dhcpRelayStatusSysdb,
                                        dhcpRelayStatusMlagSysdb )
         assert smC.mlagDhcpRelayCleanupSm
      
      if failover:
         bt2( "Failover: removing DhcpRelayP2pToSysdbSm" )
         smC.dhcpRelayP2pToSysdbSm = None
         # Peer failover case. Set the failover attribute in the dhcpRelayMlagSysdb
         # so that the prefix bindings in it get copied to dhcpRelayStatusSysdb
         # which is equivalent to changing the ownership of these bindings. We avoid
         # directly copying them to dhcpRelayStatusSysdb entity to prevent the multi
         # writer problem between DhcpRelay and Mlag agent.
         dhcpRelayStatusMlagSysdb.failover = True
      elif peerRoot():
         dhcpRelayStatusMlagSysdb.failover = False
         if not smC.dhcpRelayP2pToSysdbSm:
            bt2( "Creating dhcpRelayP2pToSysdbSm" )
            # Try/except in case peer does not support DhcpRelay V6 PD Sync
            try:
               # subdirDeprecated collection is being deprecated from EOS.
               # to be compatible with past/future releases
               # first look up in default collection ( entityPtr )
               # see message on top of this file regarding subdirDeprecated
               # lookup/creation.
               if peerRoot().get( 'dhcpRelay' ):
                  peerLocalStatus = peerRoot()[ 'dhcpRelay' ].entity[ 'status' ]
               else:
                  # lookup in subdirDeprecated collection
                  peerLocalStatus = peerRoot().subdirDeprecated[ 'dhcpRelay' ].\
                        entity[ 'status' ]
               if peerLocalStatus:
                  smC.dhcpRelayP2pToSysdbSm = ( peerLocalStatus,
                                                dhcpRelayConfigSysdb,
                                                dhcpRelayStatusSysdb,
                                                dhcpRelayStatusMlagSysdb,
                                                ctx.agent.scheduler )
            except KeyError:
               bt2( "Remote end does not support DhcpRelay V6 PD Sync" )
      else:
         bt2( "No peer root: not creating dhcpRelayP2pToSysdbSm" )

   def handleInactive():
      smC.mlagDhcpRelayCleanupSm = None
      smC.dhcpRelaySysdbToP2pSm = None
      smC.dhcpRelayP2pToSysdbSm = None

   def finishMounts():
      def handleMlagStateForDhcpRelay( mlagState, failover ):
         if mlagState in ( 'primary', 'secondary' ):
            handleActive( mlagState, failover )
         else:
            handleInactive()

      ctx.callbackIs( handleMlagStateForDhcpRelay )

   mg.close( finishMounts )
