#!/usr/bin/env python3
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import Tac
import Toggles.MplsToggleLib
import Toggles.EvpnLibToggleLib

def RouteMetricType():
   return Tac.Type( 'Mpls::RouteMetric' )

def LabelManagerClient():
   return Tac.Type( 'Mpls::LabelManagerClient' )

def labelRangeDefault( mplsConfig, rangeType ):
   return mplsConfig.labelRangeDefault[ rangeType ]

def labelRange( mplsConfig, rangeType ):
   return mplsConfig.labelRange.get( rangeType,
                                     labelRangeDefault( mplsConfig, rangeType ) )

def initMplsConfig( mplsConfig, mplsStatus ):
   # Commenting out the assert checks below
   # BUG185300 - Entity manager loads all the
   # default config plugins
   # There is configuration in Isis
   # ( DefaultConfigPlugin/Isis.py) that initializes
   # mplsConfig.labelRange making the following
   # assert statements false
   # assert len( mplsConfig.labelRange ) == 0
   # assert len( mplsConfig.labelRangeDefault ) == 0
   LabelRangeInfo = Tac.Type( 'Mpls::LabelRangeInfo' )
   # Adding 'mpls label range static'
   static = LabelRangeInfo.rangeTypeStatic
   mplsConfig.labelRange[ static ] = LabelRangeInfo.staticDefaultRange
   mplsConfig.labelRangeDefault[ static ] = LabelRangeInfo.staticDefaultRange
   mplsStatus.labelRange[ static ] = LabelRangeInfo.staticDefaultRange
   # Adding 'mpls label range dynamic'
   dynamic = LabelRangeInfo.rangeTypeDynamic
   mplsConfig.labelRange[ dynamic ] = LabelRangeInfo.dynamicDefaultRange
   mplsConfig.labelRangeDefault[ dynamic ] = LabelRangeInfo.dynamicDefaultRange
   mplsStatus.labelRange[ dynamic ] = LabelRangeInfo.dynamicDefaultRange
   # Adding 'mpls label range srgb'
   srgb = LabelRangeInfo.rangeTypeSrgb
   mplsConfig.labelRange[ srgb ] = LabelRangeInfo.srgbDefaultRange
   mplsConfig.labelRangeDefault[ srgb ] = LabelRangeInfo.srgbDefaultRange
   mplsStatus.labelRange[ srgb ] = LabelRangeInfo.srgbDefaultRange
   # Adding 'mpls label range bgp-sr'
   bgpSrgb = LabelRangeInfo.rangeTypeBgpSrgb
   mplsConfig.labelRange[ bgpSrgb ] = LabelRangeInfo.srgbDefaultRange
   mplsConfig.labelRangeDefault[ bgpSrgb ] = LabelRangeInfo.srgbDefaultRange
   mplsStatus.labelRange[ bgpSrgb ] = LabelRangeInfo.srgbDefaultRange
   # Adding 'mpls label range srlb'
   srlb = LabelRangeInfo.rangeTypeSrlb
   mplsConfig.labelRange[ srlb ] = LabelRangeInfo.srlbDefaultRange
   mplsConfig.labelRangeDefault[ srlb ] = LabelRangeInfo.srlbDefaultRange
   mplsStatus.labelRange[ srlb ] = LabelRangeInfo.srlbDefaultRange
   # Adding 'mpls label range l2evpn'
   l2evpn = LabelRangeInfo.rangeTypeL2evpn
   mplsConfig.labelRange[ l2evpn ] = LabelRangeInfo.l2evpnDefaultRange
   mplsConfig.labelRangeDefault[ l2evpn ] = LabelRangeInfo.l2evpnDefaultRange
   mplsStatus.labelRange[ l2evpn ] = LabelRangeInfo.l2evpnDefaultRange
   if Toggles.MplsToggleLib.toggleOspfSegmentRoutingMplsEnabled():
      # Adding 'mpls label range ospf-sr'
      ospfSrgb = LabelRangeInfo.rangeTypeOspfSrgb
      mplsConfig.labelRange[ ospfSrgb ] = LabelRangeInfo.srgbDefaultRange
      mplsConfig.labelRangeDefault[ ospfSrgb ] = LabelRangeInfo.srgbDefaultRange
      mplsStatus.labelRange[ ospfSrgb ] = LabelRangeInfo.srgbDefaultRange
   # Adding 'mpls label range l2evpn ethernet-segment'
   l2evpnSharedEs = LabelRangeInfo.rangeTypeL2evpnSharedEs
   mplsConfig.labelRange[ l2evpnSharedEs ] = \
         LabelRangeInfo.l2evpnSharedEsDefaultRange
   mplsConfig.labelRangeDefault[ l2evpnSharedEs ] = \
         LabelRangeInfo.l2evpnSharedEsDefaultRange
   mplsStatus.labelRange[ l2evpnSharedEs ] = \
         LabelRangeInfo.l2evpnSharedEsDefaultRange

tacTunnelType = Tac.Type( 'Tunnel::TunnelTable::TunnelType' )
tunTypeEnumDict = { 'static' : tacTunnelType.staticTunnel,
                    'ldp' : tacTunnelType.ldpTunnel,
                    'segment-routing' : tacTunnelType.srTunnel,
                    tacTunnelType.staticTunnel : 'static',
                    tacTunnelType.ldpTunnel : 'ldp',
                    tacTunnelType.srTunnel : 'segment-routing' }

def getDynamicLabelStackWithSingleLabel( label ):
   """ Create instance of Mpls::MplsDynamicLabelStack with 1 label """
   dynStack = Tac.Type( 'Mpls::MplsDynamicLabelStack' )()
   mplsLabel = Tac.Type( 'Arnet::MplsLabel' )( label )
   dynStack.labelIs( 0, mplsLabel )
   return dynStack
