#!/usr/bin/env python3
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import sys
import pickle
import json
from MssPolicyMonitor.Lib import ( getPlugin )

def makeNetwork( networks, serviceDevice ):
   rr = []
   networksD = {}
   networkM = {}
   for nw in networks:
      networkInfo = {}
      networkInfo[ 'state' ] = nw.state
      networkInfo[ 'vlan' ] = ', '.join( nw.vlans ) if nw.vlans else ''
      networkInfo[ 'mode' ] = nw.attribs[ 'mode' ] if 'mode' in \
                              nw.attribs else ''
      networkInfo[ 'virtualWire' ] = nw.attribs[ 'vwire' ] if \
                                     'vwire' in nw.attribs\
                                     else ''
      networkInfo[ 'zone' ] = nw.zone if nw.zone else ''
      networksD[ nw.name ] = networkInfo
      networkM[ 'interfaces' ] = networksD
      networkM[ 'serviceDevice' ] = serviceDevice
      rr.append( networkM )
   return rr

def returnApiResults( deviceDict, argsToPass, apiToGet ):
   api = None
   deviceType = deviceDict[ 'serviceDeviceType' ]
   group = deviceDict[ 'group' ]
   serviceDevice = argsToPass[ 'service-device' ]
   # print apiToGet
   try:
      if apiToGet == 'getAggMgrGroupMembers':
         api = getPlugin( deviceType ).getAggMgrPluginObj( deviceDict )
         servDev = api.getAggMgrGroupMembers( group )
         print( pickle.dumps( servDev ) )

      else:
         if not deviceDict[ 'isAggregationMgr' ]:
            api = getPlugin( deviceType ).getPluginObj(
               deviceDict )
         else:
            api = getPlugin( deviceType ).getPluginObj(
               deviceDict, aggMgrMemberId=serviceDevice )

         if apiToGet == 'getInterfaceNeighbors':
            intfNeighbors = api.getInterfaceNeighbors()
            print( pickle.dumps( intfNeighbors ) )

         elif apiToGet == 'getInterfacesInfo':
            networks = api.getInterfacesInfo()
            rr = makeNetwork( networks, serviceDevice )
            print( pickle.dumps( rr ) )

         elif apiToGet == 'getDeviceResources':
            resources = api.getDeviceResources()
            print( pickle.dumps( resources ) )

         elif apiToGet == 'getHighAvailabilityState':
            ha = api.getHighAvailabilityState()
            print( pickle.dumps( ha ) )
   except Exception as e: # pylint: disable-msg=W0703
      print( pickle.dumps( e ) )
   finally:
      if api:
         api.closeApiConnection()

devDict = json.loads( sys.argv[ 1 ] )
argPass = json.loads( sys.argv[ 2 ] )
apiAccessEndpoint = sys.argv[ 3 ]

# calling the api functions
returnApiResults( devDict, argPass, apiAccessEndpoint )
