# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

def getAttrValues( value, attrType ):
   '''Utility function to print the attributes in their logical order'''
   if type( value ) == str: # pylint: disable=unidiomatic-typecheck
      value = eval( value ) # pylint: disable=eval-used
   string = ''
   if attrType == 1:
      # Vlan vector
      attrs = ( 'vlanId', )
      for attr in attrs:
         # pylint: disable-next=consider-using-f-string
         string += '%s: %s, ' % ( attr, value[ attr ] )

   return string.strip().strip( ',' )

def getValueFromBytes( firstValue, lower, size ):
   value = 0
   position = 0
   for i in range( lower + size - 1, lower-1, -1 ):
      value += firstValue[ i ] << position
      position += 1
   return value

def getAttrs( firstValue, attrType ):
   values = {}
   if attrType == 1:
      # Vlan vector
      vlanId = getValueFromBytes( firstValue, 0, 2 )
      values = dict( vlanId=vlanId )
   return values
