# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import os
from Arnet import IpGenAddr
from IpLibConsts import DEFAULT_VRF

def createVrfIpPair( ipAddr, vrf ):
   return Tac.Value( "VirtualIp::VrfIpPair", vrf, IpGenAddr( ipAddr ) )

def createNameServer( ipAddr, vrf=DEFAULT_VRF, priority=0 ):
   vrfIpPair = createVrfIpPair( ipAddr, vrf )
   return Tac.Value( "System::NameServer", vrfIpPair, priority )

def netnsNameWithUniqueId( netnsName ):
   # Return a netnsName with unique ID that can be used by Xinetd to indicate
   # a new networkspace from previous generation due to delete-and-create.
   # We just use the mtime of the netns file. Python 2.x converts the high-precision
   # timestamp to a float number, but it's good enough.
   #
   # Note nsutil's netnsRunPath/setnsByName() will ignore strings after '/@' inside
   # the name.
   if netnsName and netnsName != DEFAULT_VRF:
      try:
         # pylint: disable-next=consider-using-f-string
         st = os.stat( "/var/run/netns/%s" % netnsName )
         # pylint: disable-next=consider-using-f-string
         return "%s/@%s" % ( netnsName, st.st_mtime )
      except OSError:
         pass
   return netnsName

def getRedundantPriorityInfo( priorities ):
   # Due to a limitation in glibc only five retries are supported per-query. The
   # priority implementation relies on one query per priority so only up to
   # five distinct values is supported. However, the entire range of 0-15 can be
   # configured.
   # This function returns the last well-defined and first-redundant priority values:
   # the fifth and sixth values in the sorted set of all configured values
   # respectively.
   uniquePriorities = set( priorities )
   if len( uniquePriorities ) > 5:
      sortedPriorities = sorted( uniquePriorities )
      return sortedPriorities[ 4 ], sortedPriorities[ 5 ]
   return None, None
