#!/usr/bin/env python3

# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AgentSupport
import sys
import Tac

# Sometimes it is useful to have a before/after for these paths. Let's
# dump them once at the start, and then again after we take our 30s
# cpu profile
pathsToDumpTwice = [ ( "debug/vars", "vars.json" ),
                     ( "rest/Orphanage/", "orphans" ),
                     ( "meta/collSize/", "collSize" ),
                     ( "debug/pprof/goroutine?debug=2", "goroutine.pprof" ),
                    ( "debug/pprof/heap", "heap.pprof" ), ]
pathsToDumpOnce = [ ( "yang-tree-validity", "yang_tree_validity" ),
                    ( "debug/pprof/profile?seconds=30", "profile_30s.pprof" ) ]

filepath = "/var/log/%s_dump.%s"
agentName = 'Octa'

def runAndWriteToFile( argv, filestring ):
   with open( filepath % ( agentName, filestring ), "wb" ) as f:
      Tac.run( argv, stdout=f, stderr=f, text=False )

def dumpVar( path, filestring ):
   # The port (6061) is the hardcoded port opened by OpenConfig & Octa
   argv = [ 'curl', '-s', 'localhost:6061/%s' % path ]
   try:
      runAndWriteToFile( argv, filestring )
   except Tac.SystemCommandError as e:
      if e.error ==  7:
         print( "Connection denied. Is %s running?" % agentName )
      else:
         print( "Curl error dumping variable: %s" % e.error )
      return False
   except PermissionError as e:
      print( "Curl error dumping variable: %s" % e )
      return False
   return True

def agentLogFunction():
   topArgv = [ 'top', '-bn1' ]
   runAndWriteToFile( topArgv, 'top.txt' )

   # Iterate over and collect different debug vars into corresponding files
   for t in pathsToDumpTwice:
      dumpVar( t[ 0 ], t[ 1 ] )

   for t in pathsToDumpOnce:
      dumpVar( t[ 0 ], t[ 1 ] )

   for t in pathsToDumpTwice:
      dumpVar( t[ 0 ], t[ 1 ] + '.final' )

   runAndWriteToFile( topArgv, 'top.txt.final' )

def main():
   global agentName
   if 'OpenConfig' in sys.argv[0]:
      agentName = "OpenConfig"
   AgentSupport.main( agentName, agentLogFunction=agentLogFunction )
