# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import os
import re

import OnieMountLib
import Tac

@Tac.memoize
def getOniePlatform():
   cmdline = open( "/proc/cmdline" ).read() # pylint: disable=consider-using-with
   m = re.search( r"onie_platform=(\w+)", cmdline )
   if m:
      result = m.group( 1 )
   else:
      result = ""
   return result

def grubConfigData( partition, filename="grub/grub.cfg" ):
   abootPartition = OnieMountLib.findPartByLabel( partition )
   mountPoint = f"/mnt/OnieVersionLib-{partition}"
   with OnieMountLib.Mount( abootPartition, mountPoint ):
      grubConfigFilename = os.path.join( mountPoint, filename )
      with open( grubConfigFilename ) as f:
         return f.read()

def onieVersion():
   if "SIMULATION_VMID" in os.environ:
      return ""
   try:
      data = grubConfigData( partition=OnieMountLib.ABOOT_LABEL )
   except: # pylint: disable=bare-except
      # Only Hollywood platforms should have this Aboot partition
      return ""
   m = re.search( r"# version: ([0-9]+\.[0-9]+\.[0-9]+)", data )
   return m.group( 1 ) if m else ""
