# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

X509_SPIFFE = "x509-spiffe"
METADATA = "metadata"
X509_COMMON_NAME = "x509-common-name"

usernameExtractionSource = Tac.Type( "Gnmi::usernameExtractionSource" )
usernameSourceType = Tac.Type( "Gnmi::sourceType" )
commonName = usernameExtractionSource()
commonName.source = usernameSourceType.commonName
spiffe = usernameExtractionSource()
spiffe.source = usernameSourceType.spiffe
metadata = usernameExtractionSource()
metadata.source = usernameSourceType.metadata
defaultAuthnUserPriority = [ spiffe, metadata, commonName ]
defaultAuthnUserPriorityWithCUA = [ spiffe, commonName ]
authnUsernamePriorityFromCLI = {
   X509_COMMON_NAME: commonName,
   METADATA: metadata,
   X509_SPIFFE: spiffe,
}
authnUsernamePriorityToCLI = {
   "spiffe": X509_SPIFFE,
   "metadata": METADATA,
   "commonName": X509_COMMON_NAME,
}
