#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from EosCloudInitLib import userData, runCmd, \
   processUserData, kickstartConfig, startMarkStartupConfig, \
   endMarkStartupConfig
import tempfile
import os

def cloudInit():
   # if we have already digested the config from userData,
   # we will ignore it. The user need to manually delete the
   # /mnt/flash/.openstackuserdata to force re-apply. 
   # This is needed as .userdata is always there at first boot.
   # This is in addition to  %FORCE-USER-DATA% tag.
   eqUsrDataFile = '/mnt/flash/.openstackuserdata'
   if os.path.isfile( eqUsrDataFile ):
      print( "User data already applied. Ignoring config disk" )
      # pylint: disable-next=consider-using-f-string
      print( "To reapply user data config, try after deleting %s" %
             eqUsrDataFile )
      return
   # mount the config drive if any
   mntPoint = None
   try:
      mntPoint = tempfile.mkdtemp( prefix="userdata" )
      runCmd( [ "sudo", "mount", "/dev/disk/by-label/config-2", \
                mntPoint ] )
      with open( userData, 'w' ) as uf, \
            open( mntPoint + "/openstack/latest/user_data" ) as uDataf, \
            open( kickstartConfig ) as kf, \
            open( eqUsrDataFile, "w" ) as equf:
         # Wrap kickstart file in config markers too
         uf.write( startMarkStartupConfig + "\n" )
         uf.write( kf.read() )
         uf.write( endMarkStartupConfig + "\n" )
         uData = uDataf.read()
         uf.write( uData )
         equf.write( uData )

      # Download user data. Process user data if first time boot
      print( "Processing user data" )
      configs = {}
      processUserData( configs, copyDefaultConfig=False )
   # pylint: disable=broad-except
   except Exception as e:
      # pylint: disable-next=consider-using-f-string
      print( "Caught exception %s. Ignoring openstack CloudInit" % e )
   finally:
      #Unmount config disk
      runCmd( [ "sudo", "umount", mntPoint ] )

