#!/usr/bin/env python3
# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# When we need to import items from the cli plugin in test libraries, we can run into
# issues with toggles being set after being used in the cli plugin. To work around
# this, we move the needed functions/attributes to this file and import from here
# instead

import Tac

# Because we do not allow space in tokenRules in our Cli, we define the
# dictionary for mapping Cli tokenRules to state strings.
allNeighborStates = { 'down': 'DOWN',
                      'attempt': 'ATTEMPT',
                      'init': 'INIT',
                      '2-ways': '2 WAYS',
                      'exch-start': 'EXCH START',
                      'exchange': 'EXCHANGE',
                      'loading': 'LOADING',
                      'full': 'FULL',
                      'graceful-restart': 'GRACEFUL RESTART' }

# A helper method to return domainId ( U64 ) value from domainIdStr ( string )
# Eg. "1.2.3.4.5.6" -> DomainId( 1108152157446 )
def domainIdFromStr( domainIdStr ):
   domainIdStr = domainIdStr.split( "." )
   # DomainId is 6 byte long attribute
   assert len( domainIdStr ) == 6
   domainId = 0
   for data in domainIdStr:
      # First move the domaiId by 1 byte
      domainId = domainId << 8
      # Now add the data ( current byte ) in domainId
      domainId = domainId | int( data )
   return Tac.newInstance( "Routing::Ospf::DomainId", domainId )
