#!/usr/bin/env python3
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.


import Tac
import Tracing
import Cell

__defaultTraceHandle__ = Tracing.Handle( 'PbrCli' )
t0 = Tracing.trace0

pbrRootNode = 'pbr'
# pylint: disable-next=consider-using-f-string
pbrCellRootNode = 'cell/%d/pbr' % Cell.cellId()
aclRootNode = 'acl'
configNode = 'config'
statusNode = 'status'
statusRequestDirNode = 'statusRequest/cli'
pbrConfigPath = pbrRootNode + '/input/pmap/cli'
pbrConfigType = 'Pbr::PbrConfig'
pbrStatusRequestDirPath = pbrRootNode + '/' + statusRequestDirNode
pbrStatusRequestDirType = 'PolicyMap::PolicyMapStatusRequestDir'
pbrStatusPath = pbrCellRootNode + '/' + statusNode
pbrStatusType = 'Tac::Dir'
pbrHwStatusPath = pbrRootNode + '/hardware/status/global'
pbrHwStatusType = 'Pbr::HwStatus'
aclConfigPath = aclRootNode + '/' + configNode
aclConfigType = 'Acl::Input::Config'
aclStatusPath = aclRootNode + '/' + statusNode + '/' + 'all'
aclStatusType = 'Acl::Status'
lagStatusPath = 'interface/status/eth/lag'
lagStatusType = 'Interface::EthLagIntfStatusDir'
pbrPmapClassActionType = 'PolicyMap::ClassAction'
pmapSubConfigType = 'PolicyMap::PolicyMapSubConfig'
allIntfStatusPath = 'interface/status/all'
allIntfStatusType = 'Interface::AllIntfStatusDir'

tacActionType = Tac.Type( 'PolicyMap::ActionType' )
actFwdAction = tacActionType.fwdAction
actSetDscp = tacActionType.setDscp
actPermit = tacActionType.permit
actDeny = tacActionType.deny
actSetNexthop = tacActionType.setNexthop
actSetNexthopGroup = tacActionType.setNexthopGroup
tacDscp = Tac.newInstance( 'PolicyMap::Dscp' )
actSetTtl = tacActionType.setTtl
tacTtl = Tac.newInstance( 'Ale::Ttl' )

tacPbrActionType = Tac.Type( 'PolicyMap::PbrActionType' )
tacPbrActionNone = tacPbrActionType.noAction
tacPbrActionDrop = tacPbrActionType.dropAction
tacPbrActionNextHop = tacPbrActionType.nexthopAction
tacPbrActionNextHopGroup = tacPbrActionType.nexthopGroupAction
tacPbrActionSetDscp = Tac.Type( 'PolicyMap::SetDscpAction' )
tacPbrTtlAction = Tac.Type( 'Pbr::PbrTtlAction' )
tacPbrNoAction = Tac.Type( 'Pbr::NoAction' )
tacPbrDropAction = Tac.Type( 'Pbr::DropAction' )
tacPbrNexthopAction = Tac.Type( 'PolicyMap::NexthopAction' )
tacPbrNexthopGroupAction = Tac.Type( 'Pbr::PbrNexthopGroupAction' )

tacPbrClassMapStatus = Tac.Type( 'PolicyMap::PbrClassMapStatus' )

pbrMaxAcls = 1024
pbrMaxRules = 8192
pbrMaxSequence = 0xFFFFFFFF
pbrDefaultSeqInc = 10

def nhActionStrToEnum( actionStr ):
   if actionStr == 'fwdAction':
      return actFwdAction
   elif actionStr == 'dscp':
      return actSetDscp
   else:
      return None
