# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from PhyFeatureCliLib import getPhyFeatureStatusNested
import Tac
from TypeFuture import TacLazyType

FecHistoRangeType = TacLazyType( "Hardware::Phy::FecHistogramRange" )

def FecHistoRange( rangeStr=None ):
   rangeObject = FecHistoRangeType()
   if rangeStr is None:
      return rangeObject
   else:
      rangeObject.stringValue = rangeStr
      return rangeObject

def getTh4FecHistoFeatureStatus( phyFeatureStatusSliceDir, intfName ):
   phyFeatureStatus = getPhyFeatureStatusNested( phyFeatureStatusSliceDir, intfName )
   if not phyFeatureStatus:
      return None
   caps = phyFeatureStatus.fecHistogramCapabilities
   return caps
