#!/usr/bin/env python3
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# identifies if a device is pluto and what the slotId/cellType are

import yaml
import os
from yaml.scanner import ScannerError

def formedCorrectly( config ):
   if ( not config or 'identifyCell' not in config or
        'cellType' not in config[ 'identifyCell' ] or
        'slotId' not in config[ 'identifyCell' ] ):
      return False
   else:
      return True


def identifyCell():
   # reads pluto yaml file for cellType and slotId . returns tuple
   # ( slotId, cellType, identifyError )
   yamlFile = os.environ.get( 'PLUTO_YAML_FILE', '/etc/pluto/pluto.yaml' )

   try:
      f = open( yamlFile )
   except OSError:
      # File doesn't exist
      return ( None, None, True )

   try:
      contents = yaml.load( f )
      f.close()
   except ScannerError:
      # malformed contents
      return ( None, None, True )

   if not formedCorrectly( contents ):
      return ( None, None, True )

   return ( contents[ 'identifyCell' ][ 'slotId' ],
            contents[ 'identifyCell' ][ 'cellType' ],
            False )
