# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import io
import sys
import threading
import PyServer
import ThreadLocalFile
from ArPyUtils.Types import Singleton

class StreamCatcher( metaclass=Singleton ):
   def __init__( self ):
      sys.stdout = ThreadLocalFile.ThreadLocalFile( sys.stdout )
      sys.stderr = ThreadLocalFile.ThreadLocalFile( sys.stderr )
      self.threadLocal_ = threading.local()

   def startCapture( self ):
      outputFile = io.StringIO()
      self.threadLocal_.outputFile = outputFile
      sys.stdout.setFile( outputFile )
      sys.stderr.setFile( outputFile )

   def endCapture( self ):
      try:
         sys.stdout.flush()
         sys.stderr.flush()
         sys.stdout.unsetFile()
         sys.stderr.unsetFile()
      except: # pylint: disable-msg=W0702
         pass

      try:
         outputFile = self.threadLocal_.outputFile
         output = outputFile.getvalue()
         self.threadLocal_.outputFile = None
      except: # pylint: disable-msg=W0702
         output = ''

      return output

   def __del__( self ):
      sys.stdout = sys.__stdout__
      sys.stderr = sys.__stderr__

def Plugin( ctx ):
   PyServer.StreamCatcher = StreamCatcher
