#!/usr/bin/env python3
# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from collections import OrderedDict
from TypeFuture import TacLazyType

Rfc2544BenchmarkTestEnum = TacLazyType( "Rfc2544Initiator::BenchmarkTest" )
benchmarkThroughput = Rfc2544BenchmarkTestEnum.benchmarkThroughput
benchmarkFrameLossRate = Rfc2544BenchmarkTestEnum.benchmarkFrameLossRate
benchmarkAll = Rfc2544BenchmarkTestEnum.benchmarkAll
# Only contains the tests that are supported for now.
# Maintain the order present in Rfc2544Initiator::BenchmarkTest enum.
benchmarkTestSupportedKwStr = OrderedDict()
benchmarkTestSupportedKwStr[ benchmarkThroughput ] = "throughput"
benchmarkTestSupportedKwStr[ benchmarkFrameLossRate ] = "frame-loss"
PacketSizeInBytesEnum = TacLazyType( "Rfc2544Initiator::PacketSizeInBytes" )
packetSizeKwStr = {
   PacketSizeInBytesEnum.pktSize64Bytes : '64',
   PacketSizeInBytesEnum.pktSize128Bytes : '128',
   PacketSizeInBytesEnum.pktSize256Bytes : '256',
   PacketSizeInBytesEnum.pktSize512Bytes : '512',
   PacketSizeInBytesEnum.pktSize768Bytes : '768',
   PacketSizeInBytesEnum.pktSize1024Bytes : '1024',
   PacketSizeInBytesEnum.pktSize1280Bytes : '1280',
   PacketSizeInBytesEnum.pktSize1518Bytes : '1518',
   PacketSizeInBytesEnum.pktSize1600Bytes : '1600',
   PacketSizeInBytesEnum.pktSize1728Bytes : '1728',
   PacketSizeInBytesEnum.pktSize2000Bytes : '2000',
   PacketSizeInBytesEnum.pktSize2048Bytes : '2048',
   PacketSizeInBytesEnum.pktSize2496Bytes : '2496',
   PacketSizeInBytesEnum.pktSize3584Bytes : '3584',
   PacketSizeInBytesEnum.pktSize4016Bytes : '4016',
   PacketSizeInBytesEnum.pktSize4096Bytes : '4096',
   PacketSizeInBytesEnum.pktSize8192Bytes : '8192',
   PacketSizeInBytesEnum.pktSize9104Bytes : '9104',
   PacketSizeInBytesEnum.pktSize9136Bytes : '9136',
   PacketSizeInBytesEnum.pktSize9600Bytes : '9600',
}
ExecRequestEnum = TacLazyType( "Rfc2544Initiator::ExecRequest" )
execRequestKwStr = {
   ExecRequestEnum.execStart : 'start',
   ExecRequestEnum.execStop : 'stop',
   ExecRequestEnum.execClear : 'clear',
}
TestStateEnum = TacLazyType( "FlowGenerator::FlowState" )
overallTestStateShowStr = {
   TestStateEnum.flowStateNone : "not started",
   TestStateEnum.flowStateRunning : "running",
   TestStateEnum.flowStateSuccess : "completed",
   TestStateEnum.flowStateAborted : "stopped",
   TestStateEnum.flowStateFailure : "failed",
   TestStateEnum.flowStateRestart : "failed",
}
individualTestStateShowStr = {
   TestStateEnum.flowStateNone : "not started",
   TestStateEnum.flowStateRunning : "running",
   TestStateEnum.flowStateSuccess : "success",
   TestStateEnum.flowStateAborted : "stopped",
   TestStateEnum.flowStateFailure : "failed",
   TestStateEnum.flowStateRestart : "failed",
}
TestFailureReasonEnum = TacLazyType( "Rfc2544Initiator::TestFailureReason" )
testFailureReasonShowStr = {
   TestFailureReasonEnum.intfDown : "Interface down",
   TestFailureReasonEnum.execRequestDeleted : "Test exec request deleted",
   TestFailureReasonEnum.sourceMacAddrNotFound : "Source MAC address not found",
   TestFailureReasonEnum.clientEncapNotFound : \
      "Interface client VLAN encapsulation changed or not found",
   TestFailureReasonEnum.eoamAgentRestart : "Eoam agent restarted",
   TestFailureReasonEnum.packetRateExceeded : \
      "Generator packet rate beyond the supported maximum",
   TestFailureReasonEnum.hardwareProgrammingFailed : "Hardware programming failed",
   TestFailureReasonEnum.execRequestStop : "Stopped through CLI stop command",
   TestFailureReasonEnum.throughputNotFound : "Throughput rate not found",
   TestFailureReasonEnum.throughputFailureWithProfileDuration : \
      "Throughput test failed when run for profile configured duration",
   TestFailureReasonEnum.frameLossRateFailureWithProfileDuration : \
      "Frame loss rate test failed when run for profile configured duration",
   TestFailureReasonEnum.frameLossRateSearchSpaceExhausted : \
      "Frame loss rate test failed because all trials had packet loss"
}
