# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from dataclasses import dataclass
from typing import Optional

import RcfEvalType

@dataclass( frozen=True )
class Call:
   funcName: str

@dataclass( frozen=True )
class Function:
   name: str
   valid: bool
   functionSelf: Optional[ str ]
   # If the function parameter is an invalid type it will be given
   # the None type in the funcParamTypes. For example:
   #   function foo( int_type, invalid_type ){}
   # Would give the funcParamTypes 'tuple( Int, None )'
   # during the Linking function definition we will then prevent defining
   # any functions with None in the parameters.
   funcParamTypes: tuple[ Optional[ RcfEvalType.Type ], ... ]
   functionCalls: tuple[ Call, ... ]
