# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BothTrace
import Tac

bt0 = BothTrace.tracef0
TagState = Tac.Type( "ConfigTag::ConfigTagState" )

def getConfigTagEntry( tagId, configTagIdState, configTagStatus ):
   tagStr = configTagIdState.tagIdToTagStr.get( tagId )
   if tagStr is None:
      bt0( "RcfAgent: no configTagIdState.tagIdToTagStr entry found for tagId",
           tagId )
      return None

   tagEntry = configTagStatus.configTagEntry.get( tagStr )
   if tagEntry is None:
      bt0( "RcfAgent: no configTagEntry found for tag", tagStr )
   return tagEntry

def getExcludedCodeUnits( rcfCodeUnitNames, rcfCodeUnitConfigTags, configTagIdState,
                          configTagStatus ):
   """ Helper function for filtering out code units that are associated with disabled
   or removed command-tags during compilation. Creates a set of the names of code
   units to ignore during compilation.
   """
   excludedCodeUnits = set()
   for unitName in rcfCodeUnitNames:
      tagId = rcfCodeUnitConfigTags.get( unitName )
      if tagId is None:
         continue

      tagEntry = getConfigTagEntry( tagId, configTagIdState, configTagStatus )
      if tagEntry is None:
         continue

      operState = tagEntry.operState
      # Code units are excluded from compilation if their associated command
      # tag is disabled or being removed. The removed state is a transient
      # state indicating that the config associated with this tag is in the
      # process of being deleted.
      if operState in ( TagState.disabled, TagState.removed ):
         excludedCodeUnits.add( unitName )

   return excludedCodeUnits
