# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

# Returns boolean True if /mnt/flash is RW,
#         False if /mnt/flash is RO,
#     and None if mount wasn't found
def isFlashRW():
   with open( '/proc/mounts' ) as f:
      for line in f:
         fields = list( line.split() )
         _, mntPnt, _, options = fields[ : 4 ]
         if mntPnt == '/mnt/flash':
            options = options.split( ',' )
            return 'rw' in options
   return None

def warnIfFlashIsNotWritable( ctx ):
   if not isFlashRW():
      ctx.addWarning( "Flash storage doesn't appear "
                      "to be mounted R/W. Displayed reload reason "
                      "will likely not be correct after reload." )

   return True

def Plugin( ctx ):
   # Define a set of categories for this plugin.
   category = [ "StorageDevices", "General" ]
   # Register the check with the context.
   ctx.addPolicy( warnIfFlashIsNotWritable, category )
