# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from enum import Enum

class RepoArgOp( Enum ):
   ENABLE = "enable"
   DISABLE = "disable"

class RepoArg:
   def __init__( self, op: RepoArgOp, repo: str ) -> None:
      assert isinstance( op, RepoArgOp ), f"op's type is: { type( op ) }"

      self.op = op
      self.repo = repo

   def __eq__( self, other ):
      return ( self.op == other.op and self.repo == other.repo )

   def __repr__( self ):
      return str( vars( self ) )

def createRepoArgs( args ):
   """ args come in form:
   [ ( RepoArgOp.ENABLE, 'repo1*' ), ( RepoArgOp.DISABLE, 'repo12*' ),
     ( RepoArgOp.ENABLE, 'repo123*' ) ]

   Please note that the order is important!
   """
   repoArgs = []
   for arg in args:
      repoArgs.append( RepoArg( arg[ 0 ], arg[ 1 ] ) )

   return repoArgs
