# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

def bandwidthHumanReadable( bandwidth ):
   ''' Convert bandwidth value to human readable format (bps/kbps/mbps/gbps).
   '''
   unit = "bps"
   bw = bandwidth
   if bw > 1e3:
      bw /= 1e3
      unit = "kbps"
      if bw > 1e3:
         unit = "mbps"
         bw /= 1e3
         if bw > 1e3:
            unit = "gbps"
            bw /= 1e3
   return ( bw, unit )
