#!/usr/bin/env python3
# Copyright (c) 2009, 2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

SFLOW_TRUNCATION_SIZE = 128

# Default sFlow IP/Port
defaultPort = 6343
defaultIp = '0.0.0.0'
defaultIp6 = '::'
minPort = 1
maxPort = ( 1 << 16 ) - 1

# default state
samplingEnabledDefault = True

# polling-interval
# If minPollingInterval or maxPollingInterval is changed here, please also
# update it in DmfIndigo/GentableSflowSampler.tin (SFLOW_MAX_POLLING_INTERVAL and
# SFLOW_MIN_POLLING_INTERVAL)
defaultPollingInterval = 2
minPollingInterval = 1
maxPollingInterval = 3600

# max datagram size
# default/min/max values are originally defined in Sflow/inmon/sflow.h
defaultMaxDatagramSize = 1400
minMaxDatagramSize = 200
maxMaxDatagramSize = 1500

# sample rate
defaultSampleRate = ( 1 << 20 )
minSampleRate = ( 1 << 14 )
maxSampleRate = ( 1 << 24 )
dangMinSampleRate = 1
dangMaxSampleRate = ( 1 << 32 ) - 1

# The size in bytes of the datagram header in the sFlow datagram payload (after the
# UDP header ). This should be the same size of the SFLSample_datagram_hdr as defined
# in sflow.h. The header is 24B, plus an IP address. For IPV4, the IP address is 4B,
# and for IPV6 the address is 16B
datagramHeaderSizeWithIp4Addr = 24 + 4
datagramHeaderSizeWithIp6Addr = 24 + 16

# The size in bytes of the sFlow discard flow sample header. This should be the same
# as the SFLDiscard_sample_expanded struct as defined in sflow.h (including tag and
# length)
discardFlowSampleHeaderSize = 40

# The size in bytes of the sFlow sampled header (not including the header bytes).
# This should be the same size as described by the SFLSampled_header in sflow.h
# (including tag and length)
flowSampledHeader = 24

# Printing helper method for outputing "(Default)" next
# to a value that matches the default value
def valueWithDefaultInd( value, default ):
   if value == default:
      return "%s (default)" % value # pylint: disable=consider-using-f-string
   else:
      return "%s" % value # pylint: disable=consider-using-f-string


# Added when I didn't know how to use the FocalPoint API properly,
# now might as well leave this here in case we ever want to revoke
# the ability to support LAGs.
# Can also modify Sflow::EthIntfStatusSm::handleIntfStatusChange().
LAG_SUPPORT = True

sflowSourceDefaultMsg = "Sources: None (default)"
sflowSourceMsg = "Sources:"
sflowDestDefaultMsg = "Destinations: None (default)"
sflowDestMsg = "Destinations:"
sflowDest6DefaultMsg = "Destinations (IPv6): None (default)"
sflowUdpSrcPortMsg = "UDP source port for HW sFlow: dynamic"
sflowAgentDefaultMsg = "Agent ID Addresses: None (default)"
sflowAgentMsg = "Agent ID Addresses:"
sflowAgent6DefaultMsg = "Agent ID Addresses (IPv6): None (default)"

sflowSourceErrorMsg = ( "Cannot configure sflow source when either " +
                        "\"sflow agent address\" or " +
                        "\"sflow source address\" is configured" )

SFLOWACCEL1MODE = 1
SFLOWACCEL2MODE = 2
SFLOWACCEL1MODEGEN1 = 3

SFLOW_UNKNOWN_INTERFACE = 0
SFLOW_INTERNAL_INTERFACE = 0x3FFFFFFF
SFLOW_DISCARD_REASON_TTL_EXCEEDED = 257
SFLOW_FORMAT_SINGLE = 0
SFLOW_FORMAT_DISCARD = 1
SFLOW_FORMAT_MULTIPLE = 2
