#!/usr/bin/env python3
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

#
# This file contains Shark APIs for EOS product code.
#

def mountInfo( mode, cleanup=False, enablePassive=False ):
   """Returns a MountInfo object with the given Shark-specific information."""
   mi = Tac.Value( 'TacShark::MountInfo', mode )
   mi.cleanup = cleanup
   mi.enablePassive = enablePassive

   return mi

def rootPath():
   """Returns the path where Shark files are located in the filesystem."""
   return Tac.newInstance( 'TacSharedMem::EosRootPath', '', False ).rootPath
