#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

def hexlifyNsName( ns ):
   """
   Due to ':' being a special character for snmp transports, we need to encode the ns
   name (vrf) since it can contain ':'

   net-snmp already has code to parse these strings.
   """
   return "0x%s" % ns.encode().hex() # pylint: disable=consider-using-f-string
