# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import Plugins
import Tracing
import SharedMem
import Smash
import Tac

handle = Tracing.Handle( 'ArfaSnmp' )
t0 = handle.trace0

class VxlanSnmpArfaPlugin:
   def __init__( self, ctx ):

      entityManager = ctx.entityManager()
      self.entityManager_ = entityManager

      mg = entityManager.mountGroup()

      # Input source for VniSm
      vtiStatusDir = mg.mount(
         'interface/status/eth/vxlan', 'Vxlan::VtiStatusDir', 'r' )

      # {vti,vni} counter in smash
      smi = Smash.mountInfo( 'reader' )
      shMemEm = SharedMem.entityManager( sysdbEm=entityManager )

      path = "interface/counter/vxlan/vni/current"
      vxlanCounterDir = shMemEm.doMount( path,
            "Smash::Interface::AllVxlanCounterDir", smi )

      # Get the mib (instantiated by VxlanSnmp) so we can set the
      # vxlan counter information
      sysdb = entityManager.root()
      snmpRoot = sysdb.parent[ 'snmp' ]
      mib = snmpRoot[ 'vxlan' ][ 'vxlanmib' ]
      ifMib = snmpRoot[ 'intf' ][ 'ifmib' ]

      agentRoot = sysdb.parent[ 'Snmp' ]
      self.root_ = None

      def _finishMounts():
         # per vti, vni shmem counter dir
         mib.vxlanCounterDir = vxlanCounterDir

         # We don't support vtep counters. The VNI counter could be
         # gleaned from the per vti table so no need to support the aggregated
         # vni counter table either.
         vtepCountersTableSupported = False
         vniCountersTableSupported = False
         vtiVniCountersTableSupported = True

         # We don't care about the vtep counter table, so we don't
         # mount any vtep status entities, simply pass None
         t0( 'Instantiating VxlanSnmp agent for Arfa...' )
         self.root_ = agentRoot.newEntity( 'VxlanSnmp::Agent::Root', 'VxlanSnmp' )
         self.root_.agent = ( mib, None, None, vtiStatusDir, ifMib,
               vtepCountersTableSupported, vniCountersTableSupported,
               vtiVniCountersTableSupported )

      mg.close( lambda: None )
      ctx.callbackIs( _finishMounts )

@Plugins.plugin( requires=( 'snmp/vxlan', 'snmp/intf', ) )
def Plugin( ctx ):
   t0( 'Loading VxlanSnmpArfa plugin' )
   VxlanSnmpArfaPlugin( ctx )
